USE VoxcoSystem
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Vx_sp_GetAgentActivityForContext]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [dbo].[Vx_sp_GetAgentActivityForContext]
GO
CREATE PROCEDURE [dbo].[Vx_sp_GetAgentActivityForContext]
    @contextId int,
    @userTimeZone int,
	@offset int,
	@limit int,
	@sort nvarchar(MAX),
	@filterAndSearch nvarchar(MAX),
	@SearchText nvarchar(MAX)
AS
BEGIN
	DECLARE @stmt nvarchar(MAX);

	IF @offset IS NULL
	BEGIN
		SET @offset = 0;
	END

	IF @sort IS NULL OR LEN(@sort) <= 0
	BEGIN
		SET @sort = N'[AgentActivity].[ActivityId] ASC';
	END

	IF @filterAndSearch IS NOT NULL AND LEN(@filterAndSearch) > 0
	BEGIN
		SET @filterAndSearch = ' AND ' + @filterAndSearch;
	END
	ELSE
	BEGIN
		SET @filterAndSearch = '';
	END

	SET @stmt = 'SELECT
		[ActivityId],
		[type],
		[userId],
		[projectId], 
		[respondentId],
		[dbo].[VX_fn_FromUTC]([datetime], @userTimeZone) AS [dateTime],
		[duration]
	FROM (
		SELECT
			ROW_NUMBER() OVER (ORDER BY ' + @sort + ') AS [RowNum], 
			[AgentActivity].[ActivityId],
			[AgentActivity].[type],
			[AgentActivity].[userId],
			[AgentActivity].[projectId], 
			[AgentActivity].[respondentId],
			[AgentActivity].[datetime],
			[AgentActivity].[duration]
		FROM [AgentActivity]
		INNER JOIN [tblObjects] ON [AgentActivity].[projectId] = [tblObjects].[k_Id]
		WHERE [tblObjects].[Context_Id] = @contextId' + @filterAndSearch + '
	) innerQuery
	WHERE [RowNum] > @offset' + CASE WHEN @limit IS NULL THEN '' ELSE ' AND [RowNum] <= @offset + @limit' END + '
	ORDER BY [RowNum];';

	EXEC sp_executesql @stmt, N'@contextId int, @userTimeZone int, @offset int, @limit int, @SearchText nvarchar(MAX)', @contextId, @userTimeZone, @offset, @limit, @SearchText;
END
GO
